/*****************************************************************************
 *
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
*****************************************************************************/

#include <stdio.h>
#include <opencv2/opencv.hpp>
#include <umat.hpp>
#include <iostream>
#include <fstream>
#include <iomanip>

#include "../../A53_gen/inc/apu_roiicp0_process_controller.hpp"
#include "apu_roiicp0_process_controller_policy.hpp"

#include "apu_process_controller_data.hpp"

using namespace cv;
using namespace std;
using namespace apugen;

#ifdef APEX2_EMULATE
#include "apu_app_config.hpp"
#include "apu_lib.hpp"
#include "apu_extras.hpp"
#include "acf_lib.hpp"
using namespace APEX2;
#else
#include <icp_data.h>
#include <apex.h>
#include <oal.h>
using namespace icp;
#endif
//Start of user code user_define
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

#if !defined(APEX2_EMULATE)
#include "frame_output_v234fb.h"
#define CHNL_CNT io::IO_DATA_CH3
#endif
//End of user code

int TEST_CALL()
{
#ifdef APEX2_EMULATE
  setvbuf(stdout, NULL, _IONBF, 0);
  setvbuf(stderr, NULL, _IONBF, 0);
  APU_App_Config::LoadConfig("./A53_inc/apu_app.cfg");
#endif

  #ifdef APEX2_EMULATE
    auto lImageInlet0FileName = APU_App_Config::GetValue<std::string>("INPUT_ROOT") + "in_grey_256x256.png";
  #else
    auto lImageInlet0FileName = "data/common/in_grey_256x256.png";
  #endif
  cv::Mat lImageInImageInlet0 = cv::imread(lImageInlet0FileName, CV_LOAD_IMAGE_GRAYSCALE);
  cv::Rect lInInput0Rect(120,160,128,88);
  //Start of user code declare_inputs
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code

  cv::UMat lOutImageOutlet0Data;
  cv::Rect lOutOutput0Rect(120, 160, 128, 88);
  
  //Start of user code declare_outputs
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code

  //========================================================================
  // Processing part
  //========================================================================
  int32_t retVal = 0;
  
  APU_RoiIcp0_Process_Controller RoiIcp0ProcessController(0);
  //-------------------------------- apuRoiIcp0ProcessController --------------------------------
  InputProcessControllerData<cv::Mat, RoiIcp0Input0ConversionPolicy> lRoiIcp0Input0(256, 256, VSDK_CV_8UC1);
  //Start of user code input_data_RoiIcp0
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code
  lRoiIcp0Input0.SetData(lImageInImageInlet0);
    // Verification
    if (lRoiIcp0Input0.GetDataPtr()->empty())
    {
      cout << "Input image " << lImageInlet0FileName << "was not found\n";
      exit(1);
    }
  #ifdef APEX2_EMULATE
    imshow("ImageInlet0", *lRoiIcp0Input0.GetDataPtr());
  #endif
  
  OutputProcessControllerData<cv::UMat, RoiIcp0Output0ConversionPolicy> lRoiIcp0Output0(256, 256, VSDK_CV_8UC1);
  //Start of user code output_data_RoiIcp0
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code
  retVal |= RoiIcp0ProcessController.Init();
  retVal |= RoiIcp0ProcessController.Connect(lRoiIcp0Input0.mGraphDescr, lInInput0Rect, lRoiIcp0Output0.mGraphDescr, lOutOutput0Rect);
  retVal |= RoiIcp0ProcessController.Start();
  retVal |= RoiIcp0ProcessController.Wait();
  
  //Start of user code RoiIcp0_after_run
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */
  
    //End of user code
  
  if(retVal)
  {
    cout << "RoiIcp0ProcessController error\n";
    return retVal;
  }
  lRoiIcp0Output0.GetData(lOutImageOutlet0Data);
  //Start of user code processing_part
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code

  //========================================================================
  // Display part
  //========================================================================
  // Output the picture
  #ifdef APEX2_EMULATE
    imshow("ImageOutlet0", lOutImageOutlet0Data);
    waitKey(0);
  #endif
  
  #ifdef APEX2_EMULATE
    auto lImageOutlet0FileName = APU_App_Config::GetValue<std::string>("OUTPUT_ROOT") + "out.png";
  #else
    auto lImageOutlet0FileName = "out.png";
  #endif
    imwrite(lImageOutlet0FileName, lOutImageOutlet0Data);
  
  //Start of user code display_part
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */
#if !defined(APEX2_EMULATE)
  io::FrameOutputV234Fb fbScreen(1280, 720, io::IO_DATA_DEPTH_08, CHNL_CNT);

  // Output buffer (screen size) and it's mapped version (using cv mat in order to have copyTo functions)
  vsdk::UMat umatOutput = vsdk::UMat(720, 1280, VSDK_CV_8UC3);
  {
    cv::Mat matOutput = umatOutput.getMat(ACCESS_WRITE | OAL_USAGE_CACHED);
    memset(matOutput.data, 0, 720*1280*3);

    cv::UMat inRGB(lImageInImageInlet0.rows, lImageInImageInlet0.cols, CV_8UC3);
    cv::UMat outRGB(lImageInImageInlet0.rows, lImageInImageInlet0.cols, CV_8UC3);

    cvtColor(lOutImageOutlet0Data, outRGB, CV_GRAY2RGB);
    cvtColor((cv::UMat)lRoiIcp0Input0.mGraphDescr, inRGB, CV_GRAY2RGB);

    cv::rectangle(outRGB, cv::Point(0, 0), cv::Point(lOutImageOutlet0Data.cols-1, lOutImageOutlet0Data.rows-1), cv::Scalar(255, 255, 255));
    inRGB.copyTo(matOutput(cv::Rect(0, 232, 256, 256)));
    outRGB.copyTo(matOutput(cv::Rect(300, 232, 256, 256)));
  }

  fbScreen.PutFrame(umatOutput);
#endif
  //End of user code
  
  

  return 0;
}
